
/************************************************************************
 * This file has been written as a sample solution to an exercise in a 
 * course given at the Edinburgh Parallel Computing Centre. It is made
 * freely available with the understanding that every copy of this file
 * must include this header and that EPCC takes no responsibility for
 * the use of the enclosed teaching material.
 *
 * Authors:     Joel Malard, Alan Simpson
 *
 * Contact:     epcc-tec@epcc.ed.ac.uk
 *
 * Purpose:     A program to try MPI_Comm_size and MPI_Comm_rank.
 *
 * Contents:    C source code.
 *
 ************************************************************************/

#include	<stdio.h>
#include	<mpi.h>

void main(int argc, char *argv[])
{

   int ierror, rank, size;

   MPI_Init(&argc, &argv);

   MPI_Comm_rank(MPI_COMM_WORLD, &rank);

   if (rank == 0) printf ("Hello world!\n");

   MPI_Comm_size(MPI_COMM_WORLD, &size);

   printf("I am %d out of %d.\n", rank, size);

   MPI_Finalize();

}


