
/************************************************************************
 * This file has been written as a sample solution to an exercise in a 
 * course given at the Edinburgh Parallel Computing Centre. It is made
 * freely available with the understanding that every copy of this file
 * must include this header and that EPCC takes no responsibility for
 * the use of the enclosed teaching material.
 *
 * Authors:     Joel Malard, Alan Simpson
 *
 * Contact:     epcc-tec@epcc.ed.ac.uk
 *
 * Purpose:     A program to experiment with point-to-point
 *              communications.   
 *
 * Contents:    C source code.
 *
 ************************************************************************/

#include	<stdio.h>
#include	<mpi.h>

#define proc_A 0
#define proc_B 1
#define ping 101
#define pong 101

float buffer[100000];

void processor_A (void);
void processor_B (void);

void main ( int argc, char *argv[] )
{
     int ierror, rank, size;

     MPI_Init(&argc, &argv);

     MPI_Comm_rank(MPI_COMM_WORLD, &rank);

     if (rank == proc_A) processor_A();
     else if (rank == proc_B) processor_B();

     MPI_Finalize();

}

void processor_A( void )
{

    int i, ierror;
    MPI_Status status;

    double start, finish, time;

    extern float buffer[100000];

    int length;

    printf("Length\tTotal Time\tTransfer Rate\n");

     for (length = 1; length <=  100000; length += 1000){ 

        start = MPI_Wtime();


        for (i = 1; i <= 100; i++){

            MPI_Ssend(buffer, length, MPI_FLOAT, proc_B, ping,
                      MPI_COMM_WORLD);

            MPI_Recv(buffer, length, MPI_FLOAT, proc_B, pong,
                     MPI_COMM_WORLD, &status);

        }

        finish = MPI_Wtime();

        time = finish - start;

 	printf("%d\t%f\t%f\n", length, time/200.,
               (float)(2 * 8 * 100 * length)/time);

    }

}

void processor_B( void )
{
    int i, ierror;
    MPI_Status status;

    extern float buffer[100000];

    int length;

    for (length = 1; length <= 100000; length += 1000) { 

            for (i = 1; i <= 100; i++) {

                MPI_Recv(buffer, length, MPI_FLOAT, proc_A, ping,
                         MPI_COMM_WORLD, &status);

                MPI_Ssend(buffer, length, MPI_FLOAT, proc_A, pong,
                         MPI_COMM_WORLD);

            }

    }

}

