
/************************************************************************
 * This file has been written as a sample solution to an exercise in a 
 * course given at the Edinburgh Parallel Computing Centre. It is made
 * freely available with the understanding that every copy of this file
 * must include this header and that EPCC takes no responsibility for
 * the use of the enclosed teaching material.
 *
 * Authors:     Joel Malard, Alan Simpson
 *
 * Contact:     epcc-tec@epcc.ed.ac.uk
 *
 * Purpose:     A program using derived data types and
 *              MPI_Sendrecv_replace.
 *
 * Contents:    C source code.
 *
 ************************************************************************/

#include	<stdio.h>
#include	<mpi.h>
#define msg_tag 111
#define COUNT 2

void main (int argc, char *argv[])
{
int ierror, my_rank, size;
int right, left;

int   int_rank, int_other, int_sum, i;
float float_rank, float_other, float_sum;

int          array_of_blocklengths[COUNT];
MPI_Aint     array_of_displacements[COUNT],
             first_var_address,
             second_var_address;
MPI_Datatype array_of_types[COUNT],
             newtype;

MPI_Status  status;

    /* Get process and neighbour info. */
    MPI_Init(&argc, &argv);

    MPI_Comm_rank(MPI_COMM_WORLD, &my_rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    right = my_rank + 1;
    if (right == size) right = 0;

    left = my_rank - 1;
    if (left == -1) left = size-1;

    /* Set MPI datatypes for sending and receiving partial sums. */

    array_of_blocklengths[0] = 1;
    array_of_blocklengths[1] = 1;

    MPI_Address(&int_rank, &first_var_address);
    MPI_Address(&float_rank, &second_var_address);

    array_of_displacements[0] = (MPI_Aint) 0;
    array_of_displacements[1] = second_var_address - first_var_address;

    array_of_types[0] = MPI_INT;
    array_of_types[1] = MPI_FLOAT;

    MPI_Type_struct(COUNT, array_of_blocklengths,
                           array_of_displacements, 
                           array_of_types, 
                           &newtype);

    MPI_Type_commit(&newtype);

    /* Compute global sum. */
    int_sum = 0;
    float_sum = 0;
    int_rank = my_rank;
    float_rank = (float) my_rank;

    for( i = 0; i < size; i++) {

        MPI_Sendrecv_replace(&int_rank, 1, newtype, right, msg_tag,
                             left, msg_tag, MPI_COMM_WORLD, &status);
    
        int_sum = int_sum + int_rank;
        float_sum = float_sum + float_rank;
    
    }

    printf ("PE%d:\tSum = %d\t%f\n", my_rank, int_sum, float_sum);

    MPI_Finalize();

}
