
/************************************************************************
 * This file has been written as a sample solution to an exercise in a 
 * course given at the Edinburgh Parallel Computing Centre. It is made
 * freely available with the understanding that every copy of this file
 * must include this header and that EPCC takes no responsibility for
 * the use of the enclosed teaching material.
 *
 * Authors:     Joel Malard, Alan Simpson
 *
 * Contact:     epcc-tec@epcc.ed.ac.uk
 *
 * Purpose:     A program that uses collective communications.
 *
 * Contents:    C source code.
 *
 ************************************************************************/

#include    <stdio.h>
#include    <mpi.h>

#define msg_tag 111

void main( int argc, char *argv[])
{
     int   rank, my_rank, size;
     int   int_rank, int_sum;
     float real_rank, real_sum;
     int i;

     MPI_Init( &argc, &argv);

     /* Get process info. */

     MPI_Comm_size ( MPI_COMM_WORLD, &size );
     MPI_Comm_rank ( MPI_COMM_WORLD, &my_rank );

     /* Initialize data */

     int_sum = 0;
     real_sum = 0.0;

     int_rank = my_rank;
     real_rank = (float) my_rank;

     /* Compute partial rank sums. */

     MPI_Allreduce ( &int_rank, &int_sum, 1,
                     MPI_INT, MPI_SUM, MPI_COMM_WORLD );

     MPI_Allreduce ( &real_rank, &real_sum, 1,
                     MPI_FLOAT, MPI_SUM, MPI_COMM_WORLD );

     /* Print partial sums in increasing rank order. */
 
     for ( i=0; i<size; i++ ){

        if ( my_rank == i ) printf ( "P%d:\tSum = %d\t%f\n",
                            my_rank, int_sum, real_sum );

        MPI_Barrier ( MPI_COMM_WORLD );

     }

     MPI_Finalize ( );

}
