
/************************************************************************
 * This file has been written as a sample solution to an exercise in a 
 * course given at the Edinburgh Parallel Computing Centre. It is made
 * freely available with the understanding that every copy of this file
 * must include this header and that EPCC takes no responsibility for
 * the use of the enclosed teaching material.
 *
 * Authors:     Joel Malard, Alan Simpson
 *
 * Contact:     epcc-tec@epcc.ed.ac.uk
 *
 * Purpose:     A program that uses collective communications on a two-
 *              dimensional cartesian topology.
 *
 * Contents:    C source code.
 *
 ************************************************************************/

#include	<stdio.h>
#include	<mpi.h>
#define msg_tag 111

void main (int argc, char *argv[])
{
int ierror, my_rank, size;

int   int_rank, int_sum, i;
float float_rank, float_sum;

MPI_Comm    new_comm ,ring_comm;
int         dims[2],
            periods[2],
            remain_dims[2],
            reorder;

    MPI_Init(&argc, &argv);

    /* Get process info. */

    MPI_Comm_rank(MPI_COMM_WORLD, &my_rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    /* Set 2D-cartesian topology. */

    dims[0] = 0;    dims[1] = 0;
    periods[0] = 1; periods[1] = 1;
    reorder = 1;

    MPI_Dims_create ( size, 2, dims );
    MPI_Cart_create ( MPI_COMM_WORLD, 2, dims, periods,
                      reorder, &new_comm);

    /* Set 1D-sub-topology. */

    remain_dims[0] = 0;
    remain_dims[1] = 1;

    MPI_Cart_sub ( new_comm, remain_dims, &ring_comm );

    /* Compute sums of ranks along dimension DIM. */
    int_sum = 0;
    float_sum = 0;
    int_rank = my_rank;
    float_rank = (float) my_rank;

     /* Compute partial rank sums. */

     MPI_Allreduce ( &int_rank, &int_sum, 1,
                     MPI_INT, MPI_SUM, ring_comm );

     MPI_Allreduce ( &float_rank, &float_sum, 1,
                     MPI_FLOAT, MPI_SUM, ring_comm );

     /* Print partial sums in increasing rank order. */
 
     for ( i=0; i<size; i++ ){
        if ( my_rank == i ) printf ( "P%d:\tSum = %d\t%f\n",
                            my_rank, int_sum, float_sum );
        MPI_Barrier ( MPI_COMM_WORLD );
     }

    MPI_Finalize();

}
