        PROGRAM hello
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C This file has been written as a sample solution to an exercise in a 
C course given at the Edinburgh Parallel Computing Centre. It is made
C freely available with the understanding that every copy of this file
C must include this header and that EPCC takes no responsibility for
C the use of the enclosed teaching material.
C
C Authors:    Alan Simpson, Joel Malard
C
C Contact:    epcc-tec@epcc.ed.ac.uk
C
C Purpose:    A simple MPI Program to try MPI_COMM_SIZE and
C             MPI_COMM_RANK.
C
C Contents:   F source code.
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

        IMPLICIT NONE

	INCLUDE "mpif.h"

        INTEGER ierror, rank, size

        CALL MPI_INIT(ierror)

        CALL MPI_COMM_RANK(MPI_COMM_WORLD, rank, ierror)

        IF (rank .EQ. 0) WRITE(*,*) 'Hello world!'

        CALL MPI_COMM_SIZE(MPI_COMM_WORLD, size, ierror)

        WRITE(*,*) 'I am ', rank, ' out of ', size

        CALL MPI_FINALIZE(ierror)

        STOP
        END


