        PROGRAM pingpong

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C This file has been written as a sample solution to an exercise in a 
C course given at the Edinburgh Parallel Computing Centre. It is made
C freely available with the understanding that every copy of this file
C must include this header and that EPCC takes no responsibility for
C the use of the enclosed teaching material.
C
C Authors:    Alan Simpson, Joel Malard
C
C Contact:    epcc-tec@epcc.ed.ac.uk
C
C Purpose:    A program to try point-to-point communications.
C
C Contents:   F source code.
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

        IMPLICIT NONE

	INCLUDE "mpif.h"

	INTEGER proc_A
	PARAMETER(proc_A=0)		

	INTEGER proc_B
	PARAMETER(proc_B=1)		

        INTEGER ierror, rank, size

        CALL MPI_INIT(ierror)

        CALL MPI_COMM_RANK(MPI_COMM_WORLD, rank, ierror)

        IF (rank .EQ. proc_A) THEN
	  CALL processor_A()
	ELSE IF (rank .EQ. proc_B) THEN
	  CALL processor_B()
	END IF

        CALL MPI_FINALIZE(ierror)

        STOP
        END


	SUBROUTINE processor_A()
	IMPLICIT NONE

	INCLUDE "mpif.h"

	INTEGER ping
	PARAMETER(ping=101)
	INTEGER pong
	PARAMETER(pong=101)

	INTEGER proc_A
	PARAMETER(proc_A=0)		

	INTEGER proc_B
	PARAMETER(proc_B=1)		

	INTEGER i, ierror
	INTEGER status(MPI_STATUS_SIZE)

	DOUBLE PRECISION start, finish, time

	REAL buffer(100000)
    COMMON /data/ buffer

	INTEGER length

	DO length = 1, 100000, 1000

	start = MPI_WTIME()

	DO i = 1,100

	  CALL MPI_SSEND(buffer, length, MPI_REAL,
     $                   proc_B, ping, MPI_COMM_WORLD, ierror)

	  CALL MPI_RECV(buffer, length, MPI_REAL,
     $                  proc_B, pong, MPI_COMM_WORLD,
     $                  status, ierror)

	END DO

	finish = MPI_WTIME()

	time = finish - start

C	WRITE(*,*) 'Time taken = ', time, ' seconds'

C 	WRITE(*,*) 'Bandwidth = ', REAL(2 * 8 * 100 * length)/time

 	WRITE(*,*) length, time/100., REAL(2 * 8 * 100 * length)/time

	END DO

	RETURN
	END


	SUBROUTINE processor_B()
	IMPLICIT NONE

	INCLUDE "mpif.h"

	INTEGER ping
	PARAMETER(ping=101)

	INTEGER pong
	PARAMETER(pong=101)

	INTEGER proc_A
	PARAMETER(proc_A=0)		

	INTEGER proc_B
	PARAMETER(proc_B=1)		

	INTEGER i, ierror
	INTEGER status(MPI_STATUS_SIZE)

	DOUBLE PRECISION start, finish, time

	REAL buffer(100000)
    COMMON /data/ buffer

	INTEGER length

	DO length = 1, 100000, 1000

	start = MPI_WTIME()

	DO i = 1,100

	  CALL MPI_RECV(buffer, length, MPI_REAL,
     $                  proc_A, ping, MPI_COMM_WORLD,
     $                  status, ierror)

	  CALL MPI_SSEND(buffer, length, MPI_REAL,
     $                   proc_A, pong, MPI_COMM_WORLD, ierror)

	END DO

	finish = MPI_WTIME()

	time = finish - start

C	WRITE(*,*) 'Time taken = ', time, ' seconds'

	END DO

	RETURN
	END

