      PROGRAM ring_2d

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C This file has been written as a sample solution to an exercise in a 
C course given at the Edinburgh Parallel Computing Centre. It is made
C freely available with the understanding that every copy of this file
C must include this header and that EPCC takes no responsibility for
C the use of the enclosed teaching material.
C
C Authors:    Alan Simpson, Joel Malard
C
C Contact:    epcc-tec@epcc.ed.ac.uk
C
C Purpose:    A program for experimenting with two-dimensional cartesian
C             topologies.
C
C Contents:   F source code.
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

      IMPLICIT NONE

      INCLUDE "mpif.h"

      INTEGER msg_tag
      PARAMETER(msg_tag=201)

      INTEGER ierror, rank, my_rank, size

      INTEGER right, left

      INTEGER int_rank, other_int_rank, int_sum
      REAL real_rank, other_real_rank, real_sum

      COMMON/outblock/ int_rank, real_rank
      COMMON/inblock/ other_int_rank, other_real_rank

      INTEGER first_var_address, second_var_address
      INTEGER block_type

      INTEGER length_array(2)
      INTEGER type_array(2)
      INTEGER displacement_array(2)

      INTEGER dims(2)
      LOGICAL periods(2), reorder
      INTEGER ring_rank
      INTEGER new_comm

      INTEGER send_status(MPI_STATUS_SIZE)
      INTEGER recv_status(MPI_STATUS_SIZE)
      INTEGER request

      CALL MPI_INIT(ierror)

C GET PROCESS INFO.

      CALL MPI_COMM_SIZE(MPI_COMM_WORLD, size, ierror)
      CALL MPI_COMM_RANK(MPI_COMM_WORLD, my_rank, ierror)

C SET CARTESIAN TOPOLOGY.

      dims(1) = 0
      dims(2) = 0
      periods(1) = .TRUE.
      periods(2) = .TRUE.
      reorder = .FALSE.

      CALL MPI_DIMS_CREATE(size, 2, dims, ierror)

      CALL MPI_CART_CREATE(MPI_COMM_WORLD, 2, dims, periods,
     &    reorder, new_comm, ierror)

C GET NEAREST NEIGHBOUR RANKS.

      CALL MPI_CART_SHIFT(new_comm, 1, 1, left, right, ierror)

C SET UP DERIVED DATATYPE. 

      length_array(1) = 1
      length_array(2) = 1

      type_array(1) = MPI_INTEGER
      type_array(2) = MPI_REAL

      CALL MPI_ADDRESS(int_rank, first_var_address, ierror)
      CALL MPI_ADDRESS(real_rank, second_var_address, ierror)

      displacement_array(1) = 0
      displacement_array(2) = second_var_address - first_var_address

      CALL MPI_TYPE_STRUCT(2, length_array, displacement_array,
     &                       type_array, block_type, ierror)

      CALL MPI_TYPE_COMMIT(block_type, ierror)

C initialise data
      int_sum = 0
      real_sum = 0.0

      int_rank = my_rank
      real_rank = REAL(my_rank)

100   CONTINUE

      CALL MPI_ISSEND(int_rank, 1, block_type, right, msg_tag,
     &                  new_comm, request, ierror)

      CALL MPI_RECV(other_int_rank, 1, block_type, left, msg_tag,
     &                  new_comm, recv_status, ierror)

      CALL MPI_WAIT(request, send_status, ierror)

      int_sum = int_sum + other_int_rank
      real_sum = real_sum + other_real_rank

      int_rank = other_int_rank
      real_rank = other_real_rank

      IF(other_int_rank .NE. my_rank) GOTO 100

      WRITE(*,*) 'P', my_rank, ': Sum = ', int_sum, real_sum

      CALL MPI_FINALIZE(ierror)

      STOP 'Done!'
      END
