      PROGRAM ring_1d

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C This file has been written as a sample solution to an exercise in a 
C course given at the Edinburgh Parallel Computing Centre. It is made
C freely available with the understanding that every copy of this file
C must include this header and that EPCC takes no responsibility for
C the use of the enclosed teaching material.
C
C Authors:    Alan Simpson, Joel Malard
C
C Contact:    epcc-tec@epcc.ed.ac.uk
C
C Purpose:    A program to try collective communications along a 
C             one-dimensional cartesian topology.
C
C Contents:   F source code.
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

      IMPLICIT NONE

      INCLUDE "mpif.h"

      INTEGER msg_tag
      PARAMETER(msg_tag=201)

      INTEGER ierror, rank, my_rank, size

      INTEGER int_rank, int_sum
      REAL real_rank, real_sum

      INTEGER dims(2)
      LOGICAL periods(2), reorder
      INTEGER ring_rank
      INTEGER new_comm

      CALL MPI_INIT(ierror)

C GET PROCESS INFO.

      CALL MPI_COMM_SIZE(MPI_COMM_WORLD, size, ierror)
      CALL MPI_COMM_RANK(MPI_COMM_WORLD, my_rank, ierror)

C SET CARTESIAN TOPOLOGY.

      dims(1) = size
      periods(1) = .TRUE.
      reorder = .TRUE.

      CALL MPI_CART_CREATE(MPI_COMM_WORLD, 1, dims, periods,
     &    reorder, new_comm, ierror)

C initialise data
      int_sum = 0
      real_sum = 0.0

      int_rank = my_rank
      real_rank = REAL(my_rank)

      CALL MPI_ALLREDUCE(int_rank, int_sum, 1, MPI_INTEGER,
     &                   MPI_SUM, new_comm, ierror)

      CALL MPI_ALLREDUCE(real_rank, real_sum, 1, MPI_REAL,
     &                   MPI_SUM, new_comm, ierror)

      WRITE(*,*) 'P', my_rank, ': Sum = ', int_sum, real_sum

      CALL MPI_FINALIZE(ierror)

      STOP 'Done!'
      END
