        PROGRAM ring

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C This file has been written as a sample solution to an exercise in a 
C course given at the Edinburgh Parallel Computing Centre. It is made
C freely available with the understanding that every copy of this file
C must include this header and that EPCC takes no responsibility for
C the use of the enclosed teaching material.
C
C Authors:    Alan Simpson, Joel Malard
C
C Contact:    epcc-tec@epcc.ed.ac.uk 
C
C Purpose:    A program to test non-blocking point-to-point
C             communications.
C
C Contents:   F source code.
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

        IMPLICIT NONE

	INCLUDE "mpif.h"

	INTEGER to_right
	PARAMETER(to_right=201)
	INTEGER to_left
	PARAMETER(to_left=102)


        INTEGER ierror, rank, my_rank, size

	INTEGER right, left

	INTEGER other, sum

	INTEGER send_status(MPI_STATUS_SIZE)
	INTEGER recv_status(MPI_STATUS_SIZE)
	INTEGER request

        CALL MPI_INIT(ierror)

        CALL MPI_COMM_RANK(MPI_COMM_WORLD, my_rank, ierror)
        CALL MPI_COMM_SIZE(MPI_COMM_WORLD, size, ierror)

	right = my_rank + 1
	IF (right .EQ. size) right = 0

	left = my_rank - 1
	IF (left .EQ. -1) left = size-1

	sum = 0
	rank = my_rank
100	CONTINUE

	CALL MPI_ISSEND(rank, 1, MPI_INTEGER, right, to_right,
     &                  MPI_COMM_WORLD, request, ierror)

	CALL MPI_RECV(other, 1, MPI_INTEGER, left, to_right,
     &                  MPI_COMM_WORLD, recv_status, ierror)

	CALL MPI_WAIT(request, send_status, ierror)

	sum = sum + other
	rank = other

	IF(other .NE. my_rank) GOTO 100

	WRITE(*,*) sum

        CALL MPI_FINALIZE(ierror)

        STOP
        END
