      PROGRAM ring

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C This file has been written as a sample solution to an exercise in a 
C course given at the Edinburgh Parallel Computing Centre. It is made
C freely available with the understanding that every copy of this file
C must include this header and that EPCC takes no responsibility for
C the use of the enclosed teaching material.
C
C Authors:    Alan Simpson, Joel Malard
C
C Contact:    epcc-tec@epcc.ed.ac.uk
C
C Purpose:    Another program for experimenting with derived
C             data types.
C
C Contents:   F source code.
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

      IMPLICIT NONE

      INCLUDE "mpif.h"

      INTEGER msg_tag
      PARAMETER(msg_tag=111)

      INTEGER ierror, rank, my_rank, size

      INTEGER right, left

      INTEGER int_rank, other_int_rank, int_sum
      REAL real_rank, other_real_rank, real_sum

      COMMON/outblock/ int_rank, real_rank
      COMMON/inblock/ other_int_rank, other_real_rank

      INTEGER first_var_address, second_var_address
      INTEGER block_type

      INTEGER length_array(2)
      INTEGER type_array(2)
      INTEGER displacement_array(2)

      INTEGER integer_extent

      INTEGER status(MPI_STATUS_SIZE)

      CALL MPI_INIT(ierror)

C GET PROCESS AND NEIGHBOUR INFO.

      CALL MPI_COMM_RANK(MPI_COMM_WORLD, my_rank, ierror)
      CALL MPI_COMM_SIZE(MPI_COMM_WORLD, size, ierror)

      right = my_rank + 1
      IF (right .EQ. size) right = 0

      left = my_rank - 1
      IF (left .EQ. -1) left = size-1

C SET UP DERIVED DATATYPE. 

      length_array(1) = 1
      length_array(2) = 1

      type_array(1) = MPI_INTEGER
      type_array(2) = MPI_REAL

      CALL MPI_ADDRESS(int_rank, first_var_address, ierror)
      CALL MPI_ADDRESS(real_rank, second_var_address, ierror)

      displacement_array(1) = 0
      displacement_array(2) = second_var_address - first_var_address

      CALL MPI_TYPE_STRUCT(2, length_array, displacement_array,
     &                       type_array, block_type, ierror)

      CALL MPI_TYPE_COMMIT(block_type, ierror)

C initialise data
      int_sum = 0
      real_sum = 0.0

      int_rank = my_rank
      real_rank = REAL(my_rank)

100   CONTINUE

      CALL MPI_Sendrecv_replace(int_rank, 1, block_type, right,
     &         msg_tag, left, msg_tag, MPI_COMM_WORLD, status, ierror)

      int_sum = int_sum + int_rank
      real_sum = real_sum + real_rank

      IF(int_rank .NE. my_rank) GOTO 100

      WRITE(*,*) 'P', my_rank, ': Sum = ', int_sum, real_sum

      CALL MPI_FINALIZE(ierror)

      STOP 'Done!'
      END
