      PROGRAM ring_2d

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C This file has been written as a sample solution to an exercise in a 
C course given at the Edinburgh Parallel Computing Centre. It is made
C freely available with the understanding that every copy of this file
C must include this header and that EPCC takes no responsibility for
C the use of the enclosed teaching material.
C
C Authors:    Alan Simpson, Joel Malard
C
C Contact:    epcc-tec@epcc.ed.ac.uk
C
C Purpose:    A program to try collective communications along a 
C             two-dimensional cartesian topology.
C
C Contents:   F source code.
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

      IMPLICIT NONE

      INCLUDE "mpif.h"

      INTEGER msg_tag
      PARAMETER(msg_tag=111)

      INTEGER ierror, rank, my_rank, size

      INTEGER right, left, I

      INTEGER int_rank, int_sum
      REAL real_rank, real_sum

      INTEGER dims(2)
      LOGICAL periods(2), reorder, remain_dims(2)
      INTEGER cart_comm, sub_comm

      CALL MPI_INIT(ierror)

C GET PROCESS INFO.

      CALL MPI_COMM_SIZE(MPI_COMM_WORLD, size, ierror)
      CALL MPI_COMM_RANK(MPI_COMM_WORLD, my_rank, ierror)

C SET 2D-CARTESIAN TOPOLOGY.

      dims(1) = 0
      dims(2) = 0
      periods(1) = .TRUE.
      periods(2) = .TRUE.
      reorder = .FALSE.

      CALL MPI_DIMS_CREATE(size, 2, dims, ierror)

      CALL MPI_CART_CREATE(MPI_COMM_WORLD, 2, dims, periods,
     &    reorder, cart_comm, ierror)

C SET 1D-SUB-TOPOLOGY

      remain_dims(1) = .FALSE.
      remain_dims(2) = .TRUE.

      CALL MPI_CART_SUB(cart_comm,remain_dims,sub_comm,ierror)

C INITIALISE DATA

      int_sum = 0
      real_sum = 0.0

      int_rank = my_rank
      real_rank = REAL(my_rank)

C COMPUTE SUMS OF RANKS ALONG ONE DIMENSION OF THE 2D PROCESS MESH.

      CALL MPI_ALLREDUCE(int_rank, int_sum, 1, MPI_INTEGER,
     &                   MPI_SUM, sub_comm, ierror)

      CALL MPI_ALLREDUCE(real_rank, real_sum, 1, MPI_REAL,
     &                   MPI_SUM, sub_comm, ierror)

C PRINT PARTIAL SUMS IN RANK ORDER.

      DO I = 1, size

         IF ( my_rank .EQ. I ) WRITE(*,*) 'P', my_rank, ': Sum = ',
     &                                    int_sum, real_sum

         CALL MPI_BARRIER ( MPI_COMM_WORLD, ierror )

      END DO

      CALL MPI_FINALIZE(ierror)

      STOP 'Done!'
      END
